using System;
using Server.Network;
using Server.Items;

namespace Server.Items
{
	[FlipableAttribute( 0x26CE, 0x26CF )]
	public class LevelTwoHandedSword : BaseLevelSword
	{
		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.WhirlwindAttack; } }
		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.Disarm; } }
// 		public override WeaponAbility PrimaryAbility{ get{ return WeaponAbility.DoubleStrike; } }
// 		public override WeaponAbility SecondaryAbility{ get{ return WeaponAbility.BleedAttack; } }
      public override WeaponAnimation DefAnimation{ get{ return WeaponAnimation.Slash2H; } }

		public override int AosStrengthReq{ get{ return 45; } }
		public override int AosMinDamage{ get{ return 16; } }
		public override int AosMaxDamage{ get{ return 20; } }
		public override int AosSpeed{ get{ return 35; } }

		public override int OldStrengthReq{ get{ return 45; } }
		public override int OldMinDamage{ get{ return 7; } }
		public override int OldMaxDamage{ get{ return 33; } }
		public override int OldSpeed{ get{ return 35; } }

		public override int DefHitSound{ get{ return 0x237; } }
		public override int DefMissSound{ get{ return 0x238; } }

		public override int InitMinHits{ get{ return 51; } }
		public override int InitMaxHits{ get{ return 110; } }

		[Constructable]
		public LevelTwoHandedSword() : base( 0x26CE )
		{
			Name = "two handed sword";
         Weight = 7.0;
         Layer = Layer.TwoHanded;
		}

		public LevelTwoHandedSword( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}